package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicationControllerCondition describes the state of a replication controller at a certain point.
 *
 *  @param             `type`  Type of replication controller condition.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param lastTransitionTime  The last time the condition transitioned from one status to another.
 *  @param            message  A human readable message indicating details about the transition.
 *  @param             reason  The reason for the condition's last transition.
*/
case class ReplicationControllerCondition(
  `type`: String,
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object ReplicationControllerCondition {
  implicit lazy val encoder: Encoder.AsObject[ReplicationControllerCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicationControllerCondition] = deriveDecoder
}
