package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ResourceFieldSelector represents container resources (cpu, memory) and their output format
 *
 *  @param      resource  Required: resource to select
 *  @param containerName  Container name: required for volumes, optional for env vars
 *  @param       divisor  Specifies the output format of the exposed resources, defaults to "1"
*/
case class ResourceFieldSelector(
  resource: String,
  containerName: Option[String] = None,
  divisor: Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
)

object ResourceFieldSelector {
  implicit lazy val encoder: Encoder.AsObject[ResourceFieldSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceFieldSelector] = deriveDecoder
}
