package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ResourceQuotaStatus defines the enforced hard limits and observed use.
 *
 *  @param hard  Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
 *  @param used  Used is the current observed total usage of the resource in the namespace.
*/
case class ResourceQuotaStatus(
  hard: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  used: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object ResourceQuotaStatus {
  implicit lazy val encoder: Encoder.AsObject[ResourceQuotaStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceQuotaStatus] = deriveDecoder
}
