package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ResourceRequirements describes the compute resource requirements.
 *
 *  @param   limits  Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
 *  @param requests  Requests describes the minimum amount of compute resources required. If Requests is omitted for a container,
 *                   it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More
 *                   info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
*/
case class ResourceRequirements(
  limits: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  requests: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object ResourceRequirements {
  implicit lazy val encoder: Encoder.AsObject[ResourceRequirements] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceRequirements] = deriveDecoder
}
