package io.k8s.api.rbac.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** RoleRef contains information that points to the role being used
 *
 *  @param apiGroup  APIGroup is the group for the resource being referenced
 *  @param     kind  Kind is the type of resource being referenced
 *  @param     name  Name is the name of resource being referenced
*/
case class RoleRef(
  apiGroup: String,
  kind: String,
  name: String
)

object RoleRef {
  implicit lazy val encoder: Encoder.AsObject[RoleRef] = deriveEncoder
  implicit lazy val decoder: Decoder[RoleRef] = deriveDecoder
}
