package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ScaleSpec describes the attributes of a scale subresource.
 *
 *  @param replicas  desired number of instances for the scaled object.
*/
case class ScaleSpec(
  replicas: Option[Int] = None
)

object ScaleSpec {
  implicit lazy val encoder: Encoder.AsObject[ScaleSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[ScaleSpec] = deriveDecoder
}
