package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ScaleStatus represents the current status of a scale subresource.
 *
 *  @param replicas  actual number of observed instances of the scaled object.
 *  @param selector  label query over pods that should match the replicas count. This is same as the label selector but in
 *                   the string format to avoid introspection by clients. The string will be in the same format as the query-param
 *                   syntax. More info about label selectors: http://kubernetes.io/docs/user-guide/labels#label-selectors
*/
case class ScaleStatus(
  replicas: Int,
  selector: Option[String] = None
)

object ScaleStatus {
  implicit lazy val encoder: Encoder.AsObject[ScaleStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ScaleStatus] = deriveDecoder
}
