package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ServiceStatus represents the current status of a service.
 *
 *  @param   conditions  Current service state
 *  @param loadBalancer  LoadBalancer contains the current status of the load-balancer, if one is present.
*/
case class ServiceStatus(
  conditions: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None,
  loadBalancer: Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
)

object ServiceStatus {
  implicit lazy val encoder: Encoder.AsObject[ServiceStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceStatus] = deriveDecoder
}
