package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** SessionAffinityConfig represents the configurations of session affinity.
 *
 *  @param clientIP  clientIP contains the configurations of Client IP based session affinity.
*/
case class SessionAffinityConfig(
  clientIP: Option[io.k8s.api.core.v1.ClientIPConfig] = None
)

object SessionAffinityConfig {
  implicit lazy val encoder: Encoder.AsObject[SessionAffinityConfig] = deriveEncoder
  implicit lazy val decoder: Decoder[SessionAffinityConfig] = deriveDecoder
}
