package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a StorageOS persistent volume resource.
 *
 *  @param          fsType  fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating
 *                          system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
 *  @param        readOnly  readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts
 *  @param       secretRef  secretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified,
 *                          default values will be attempted.
 *  @param      volumeName  volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within
 *                          a namespace.
 *  @param volumeNamespace  volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified
 *                          then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within
 *                          StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour.
 *                          Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist
 *                          within StorageOS will be created.
*/
case class StorageOSPersistentVolumeSource(
  fsType: Option[String] = None,
  readOnly: Option[Boolean] = None,
  secretRef: Option[io.k8s.api.core.v1.ObjectReference] = None,
  volumeName: Option[String] = None,
  volumeNamespace: Option[String] = None
)

object StorageOSPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[StorageOSPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[StorageOSPersistentVolumeSource] = deriveDecoder
}
