package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** TCPSocketAction describes an action based on opening a socket
 *
 *  @param port  Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be
 *               an IANA_SVC_NAME.
 *  @param host  Optional: Host name to connect to, defaults to the pod IP.
*/
case class TCPSocketAction(
  port: com.goyeau.kubernetes.client.IntOrString,
  host: Option[String] = None
)

object TCPSocketAction {
  implicit lazy val encoder: Encoder.AsObject[TCPSocketAction] = deriveEncoder
  implicit lazy val decoder: Decoder[TCPSocketAction] = deriveDecoder
}
