package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced.
 *
 *  @param       spec  Specification of the desired attach/detach volume behavior. Populated by the Kubernetes system.
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param     status  Status of the VolumeAttachment request. Populated by the entity completing the attach or detach operation,
 *                     i.e. the external-attacher.
*/
case class VolumeAttachment(
  spec: io.k8s.api.storage.v1.VolumeAttachmentSpec,
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  status: Option[io.k8s.api.storage.v1.VolumeAttachmentStatus] = None
)

object VolumeAttachment {
  implicit lazy val encoder: Encoder.AsObject[VolumeAttachment] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeAttachment] = deriveDecoder
}
