package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** VolumeAttachmentStatus is the status of a VolumeAttachment request.
 *
 *  @param           attached  Indicates the volume is successfully attached. This field must only be set by the entity completing
 *                             the attach operation, i.e. the external-attacher.
 *  @param        attachError  The last error encountered during attach operation, if any. This field must only be set by the
 *                             entity completing the attach operation, i.e. the external-attacher.
 *  @param attachmentMetadata  Upon successful attach, this field is populated with any information returned by the attach
 *                             operation that must be passed into subsequent WaitForAttach or Mount calls. This field must only
 *                             be set by the entity completing the attach operation, i.e. the external-attacher.
 *  @param        detachError  The last error encountered during detach operation, if any. This field must only be set by the
 *                             entity completing the detach operation, i.e. the external-attacher.
*/
case class VolumeAttachmentStatus(
  attached: Boolean,
  attachError: Option[io.k8s.api.storage.v1.VolumeError] = None,
  attachmentMetadata: Option[Map[String, String]] = None,
  detachError: Option[io.k8s.api.storage.v1.VolumeError] = None
)

object VolumeAttachmentStatus {
  implicit lazy val encoder: Encoder.AsObject[VolumeAttachmentStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeAttachmentStatus] = deriveDecoder
}
