package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** volumeDevice describes a mapping of a raw block device within a container.
 *
 *  @param       name  name must match the name of a persistentVolumeClaim in the pod
 *  @param devicePath  devicePath is the path inside of the container that the device will be mapped to.
*/
case class VolumeDevice(
  name: String,
  devicePath: String
)

object VolumeDevice {
  implicit lazy val encoder: Encoder.AsObject[VolumeDevice] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeDevice] = deriveDecoder
}
