package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a vSphere volume resource.
 *
 *  @param        volumePath  volumePath is the path that identifies vSphere volume vmdk
 *  @param            fsType  fsType is filesystem type to mount. Must be a filesystem type supported by the host operating
 *                            system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
 *  @param   storagePolicyID  storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the
 *                            StoragePolicyName.
 *  @param storagePolicyName  storagePolicyName is the storage Policy Based Management (SPBM) profile name.
*/
case class VsphereVirtualDiskVolumeSource(
  volumePath: String,
  fsType: Option[String] = None,
  storagePolicyID: Option[String] = None,
  storagePolicyName: Option[String] = None
)

object VsphereVirtualDiskVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[VsphereVirtualDiskVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[VsphereVirtualDiskVolumeSource] = deriveDecoder
}
