/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant;
import cats.Invariant$;
import cats.Monad;
import cats.MonadError;
import cats.NonEmptyParallel$;
import cats.Semigroupal;
import cats.Semigroupal$;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.package;
import cats.syntax.EitherOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.ParallelSequenceOps1$;
import cats.syntax.package;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.goyeau.kubernetes.client.KubeConfig;
import com.goyeau.kubernetes.client.KubeConfigNotFoundError$;
import com.goyeau.kubernetes.client.util.AuthInfoExec;
import com.goyeau.kubernetes.client.util.Text$;
import com.goyeau.kubernetes.client.util.Yamls$;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.Credentials;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.headers.Authorization;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple11;
import scala.Tuple2;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class KubeConfig$
implements Serializable {
    public static final KubeConfig$ MODULE$ = new KubeConfig$();
    private static final String EnvKubeConfig = "KUBECONFIG";
    private static final String EnvHome;
    private static final String EnvHomeDrive;
    private static final String EnvHomePath;
    private static final String EnvUserProfile;
    private static final String KubeConfigDir;
    private static final String KubeConfigFile;
    private static final String ServiceAccountRoot;
    private static final String ServiceAccountCAPath;
    private static final String ServiceAccountTokenPath;
    private static final String EnvServiceHost;
    private static final String EnvServicePort;
    private static volatile int bitmap$init$0;

    static {
        bitmap$init$0 |= 1;
        EnvHome = "HOME";
        bitmap$init$0 |= 2;
        EnvHomeDrive = "HOMEDRIVE";
        bitmap$init$0 |= 4;
        EnvHomePath = "HOMEPATH";
        bitmap$init$0 |= 8;
        EnvUserProfile = "USERPROFILE";
        bitmap$init$0 |= 0x10;
        KubeConfigDir = ".kube";
        bitmap$init$0 |= 0x20;
        KubeConfigFile = "config";
        bitmap$init$0 |= 0x40;
        ServiceAccountRoot = "/var/run/secrets/kubernetes.io/serviceaccount";
        bitmap$init$0 |= 0x80;
        ServiceAccountCAPath = new StringBuilder(7).append(MODULE$.ServiceAccountRoot()).append("/ca.crt").toString();
        bitmap$init$0 |= 0x100;
        ServiceAccountTokenPath = new StringBuilder(6).append(MODULE$.ServiceAccountRoot()).append("/token").toString();
        bitmap$init$0 |= 0x200;
        EnvServiceHost = "KUBERNETES_SERVICE_HOST";
        bitmap$init$0 |= 0x400;
        EnvServicePort = "KUBERNETES_SERVICE_PORT";
        bitmap$init$0 |= 0x800;
    }

    private String EnvKubeConfig() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 54");
        }
        return EnvKubeConfig;
    }

    private String EnvHome() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 55");
        }
        return EnvHome;
    }

    private String EnvHomeDrive() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 56");
        }
        return EnvHomeDrive;
    }

    private String EnvHomePath() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 57");
        }
        return EnvHomePath;
    }

    private String EnvUserProfile() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 58");
        }
        return EnvUserProfile;
    }

    private String KubeConfigDir() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 59");
        }
        return KubeConfigDir;
    }

    private String KubeConfigFile() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 60");
        }
        return KubeConfigFile;
    }

    private String ServiceAccountRoot() {
        if ((bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 61");
        }
        return ServiceAccountRoot;
    }

    private String ServiceAccountCAPath() {
        if ((bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 62");
        }
        return ServiceAccountCAPath;
    }

    private String ServiceAccountTokenPath() {
        if ((bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 63");
        }
        return ServiceAccountTokenPath;
    }

    private String EnvServiceHost() {
        if ((bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 64");
        }
        return EnvServiceHost;
    }

    private String EnvServicePort() {
        if ((bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/KubeConfig.scala: 65");
        }
        return EnvServicePort;
    }

    public <F> F standard(Logger<F> evidence$1, Async<F> F) {
        return (F)this.findFromEnv(evidence$1, F).orElse((Function0 & Serializable)() -> MODULE$.findConfigInHomeDir((Option<String>)package.all$.MODULE$.none(), evidence$1, F), F).orElse((Function0 & Serializable)() -> MODULE$.findClusterConfig(evidence$1, F), F).getOrRaise((Function0 & Serializable)() -> KubeConfigNotFoundError$.MODULE$, F);
    }

    public <F> F fromEnv(Logger<F> evidence$2, Async<F> F) {
        return (F)this.findFromEnv(evidence$2, F).getOrRaise((Function0 & Serializable)() -> KubeConfigNotFoundError$.MODULE$, F);
    }

    public <F> F inHomeDir(Logger<F> evidence$3, Async<F> F) {
        return (F)this.findConfigInHomeDir((Option<String>)package.all$.MODULE$.none(), evidence$3, F).getOrRaise((Function0 & Serializable)() -> KubeConfigNotFoundError$.MODULE$, F);
    }

    public <F> F inHomeDir(String contextName, Logger<F> evidence$4, Async<F> F) {
        return (F)this.findConfigInHomeDir((Option<String>)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)contextName)), evidence$4, F).getOrRaise((Function0 & Serializable)() -> KubeConfigNotFoundError$.MODULE$, F);
    }

    public <F> F cluster(Logger<F> evidence$5, Async<F> F) {
        return (F)this.findClusterConfig(evidence$5, F).getOrRaise((Function0 & Serializable)() -> KubeConfigNotFoundError$.MODULE$, F);
    }

    public <F> F fromFile(Path kubeconfig, Async<F> evidence$6, Logger<F> evidence$7) {
        return Yamls$.MODULE$.fromKubeConfigFile(kubeconfig, (Option<String>)None$.MODULE$, evidence$6, evidence$7, Files$.MODULE$.forAsync(evidence$6));
    }

    public <F> F fromFile(Path kubeconfig, String contextName, Async<F> evidence$8, Logger<F> evidence$9) {
        return Yamls$.MODULE$.fromKubeConfigFile(kubeconfig, (Option<String>)Option$.MODULE$.apply((Object)contextName), evidence$8, evidence$9, Files$.MODULE$.forAsync(evidence$8));
    }

    public <F> F apply(Path kubeconfig, Async<F> evidence$10, Logger<F> evidence$11) {
        return this.fromFile(kubeconfig, evidence$10, evidence$11);
    }

    public <F> F apply(Path kubeconfig, String contextName, Async<F> evidence$12, Logger<F> evidence$13) {
        return this.fromFile(kubeconfig, contextName, evidence$12, evidence$13);
    }

    public <F> F of(Uri server, Option<F> authorization, Option<String> caCertData, Option<Path> caCertFile, Option<String> clientCertData, Option<Path> clientCertFile, Option<String> clientKeyData, Option<Path> clientKeyFile, Option<String> clientKeyPass, Option<AuthInfoExec> authInfoExec, ApplicativeError<F, Throwable> evidence$14) {
        Either configOrError = (Either)package.all$.MODULE$.toFunctorOps((Object)EitherOps$.MODULE$.leftMap$extension(package.all$.MODULE$.catsSyntaxEither((Either)ParallelSequenceOps1$.MODULE$.parSequence$extension(package.all$.MODULE$.catsSyntaxParallelSequence1((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(caCertData, caCertFile)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined())), (Object)"caCertData and caCertFile cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(clientCertData, clientCertFile)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined())), (Object)"clientCertData and clientCertFile cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(clientKeyData, clientKeyFile)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined())), (Object)"clientKeyData and clientKeyFile cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(authorization, authInfoExec)).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).isDefined())), (Object)"authorization and authInfoExec cannot be specified at the same time"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)authInfoExec.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KubeConfig$.$anonfun$of$1(x$2))))), (Object)"interactiveMode=Always is not supported"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)authInfoExec.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KubeConfig$.$anonfun$of$2(x$3))))), (Object)"provideClusterInfo=true is not supported"), (List)Nil$.MODULE$)))))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                boolean badCondition = tuple2._1$mcZ$sp();
                String error = (String)tuple2._2();
                return package$.MODULE$.Either().cond(!badCondition, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (Function0 & Serializable)() -> NonEmptyList$.MODULE$.one((Object)error));
            }
            throw new MatchError((Object)tuple2);
        }), UnorderedFoldable$.MODULE$.catsTraverseForList()), UnorderedFoldable$.MODULE$.catsTraverseForList(), NonEmptyParallel$.MODULE$.catsParallelForEitherValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))), (Function1 & Serializable)errors -> new IllegalArgumentException(errors.toList().mkString("; "))), (Functor)Invariant$.MODULE$.catsMonadErrorForEither()).as(new KubeConfig<F>(server, authorization, caCertData, caCertFile, clientCertData, clientCertFile, clientKeyData, clientKeyFile, clientKeyPass, authInfoExec, package.all$.MODULE$.none()));
        return (F)package.ApplicativeThrow$.MODULE$.apply(evidence$14).fromEither(configOrError);
    }

    public <F> None$ of$default$2() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$3() {
        return None$.MODULE$;
    }

    public <F> Option<Path> of$default$4() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$5() {
        return None$.MODULE$;
    }

    public <F> Option<Path> of$default$6() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$7() {
        return None$.MODULE$;
    }

    public <F> Option<Path> of$default$8() {
        return None$.MODULE$;
    }

    public <F> Option<String> of$default$9() {
        return None$.MODULE$;
    }

    public <F> Option<AuthInfoExec> of$default$10() {
        return None$.MODULE$;
    }

    private <F> OptionT<F, KubeConfig<F>> findFromEnv(Logger<F> evidence$15, Async<F> F) {
        return this.envPath(this.EnvKubeConfig(), F).flatMapF((Function1 & Serializable)x$4 -> MODULE$.checkExists((Path)x$4, F), F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$15).debug((Function0 & Serializable)() -> new StringBuilder(39).append(MODULE$.EnvKubeConfig()).append(" is not defined, or path does not exist").toString()), F).semiflatTap((Function1 & Serializable)path -> Logger$.MODULE$.apply(evidence$15).debug((Function0 & Serializable)() -> new StringBuilder(34).append("using configuration specified by ").append(MODULE$.EnvKubeConfig()).append("=").append(path).toString()), F).semiflatMap((Function1 & Serializable)x$5 -> MODULE$.fromFile((Path)x$5, F, evidence$15), F);
    }

    private <F> OptionT<F, KubeConfig<F>> findConfigInHomeDir(Option<String> contextName, Logger<F> evidence$16, Async<F> F) {
        return this.findHomeDir(evidence$16, F).map((Function1 & Serializable)homeDir -> homeDir.resolve(MODULE$.KubeConfigDir()).resolve(MODULE$.KubeConfigFile()), F).flatMapF((Function1 & Serializable)x$6 -> MODULE$.checkExists((Path)x$6, F), F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$16).debug((Function0 & Serializable)() -> new StringBuilder(18).append("~/").append(MODULE$.KubeConfigDir()).append("/").append(MODULE$.KubeConfigFile()).append(" does not exist").toString()), F).semiflatTap((Function1 & Serializable)path -> Logger$.MODULE$.apply(evidence$16).debug((Function0 & Serializable)() -> new StringBuilder(33).append("using configuration specified in ").append(path).toString()), F).semiflatMap((Function1 & Serializable)path -> contextName.fold((Function0 & Serializable)() -> MODULE$.fromFile((Path)path, F, evidence$16), (Function1 & Serializable)x$7 -> MODULE$.fromFile((Path)path, (String)x$7, F, evidence$16)), F);
    }

    private <F> OptionT<F, KubeConfig<F>> findClusterConfig(Logger<F> evidence$17, Async<F> F) {
        return ((OptionT)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(new Tuple4((Object)this.path(this.ServiceAccountTokenPath(), F).flatMapF((Function1 & Serializable)x$8 -> MODULE$.checkExists((Path)x$8, F), F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$17).debug((Function0 & Serializable)() -> new StringBuilder(15).append(MODULE$.ServiceAccountTokenPath()).append(" does not exist").toString()), F), (Object)this.path(this.ServiceAccountCAPath(), F).flatMapF((Function1 & Serializable)x$9 -> MODULE$.checkExists((Path)x$9, F), F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$17).debug((Function0 & Serializable)() -> new StringBuilder(15).append(MODULE$.ServiceAccountCAPath()).append(" does not exist").toString()), F), (Object)this.env(this.EnvServiceHost(), F).mapFilter((Function1 & Serializable)value -> IpAddress$.MODULE$.fromString(value), F).map((Function1 & Serializable)value -> Uri.Host$.MODULE$.fromIpAddress(value), F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$17).debug((Function0 & Serializable)() -> new StringBuilder(42).append(MODULE$.EnvServiceHost()).append(" is not defined, or not a valid IP address").toString()), F), (Object)this.env(this.EnvServicePort(), F).mapFilter((Function1 & Serializable)value -> Port$.MODULE$.fromString(value), F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$17).debug((Function0 & Serializable)() -> new StringBuilder(43).append(MODULE$.EnvServicePort()).append(" is not defined, or not a valid port number").toString()), F))).tupled((Invariant)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F), (Semigroupal)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F))).semiflatTap((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                Path tokenPath = (Path)tuple4._1();
                Path caPath = (Path)tuple4._2();
                Uri.Host serviceHost = (Uri.Host)tuple4._3();
                Port servicePort = (Port)tuple4._4();
                return Logger$.MODULE$.apply(evidence$17).debug((Function0 & Serializable)() -> new StringBuilder(46).append("using the in-cluster configuration: ").append(MODULE$.EnvServiceHost()).append("=").append(serviceHost).append(", ").append(MODULE$.EnvServicePort()).append("=").append(servicePort).append(", ").append(MODULE$.ServiceAccountTokenPath()).append("=").append(tokenPath).append(", ").append(MODULE$.ServiceAccountCAPath()).append("=").append(caPath).toString());
            }
            throw new MatchError((Object)tuple4);
        }, F).semiflatMap((Function1 & Serializable)x0$2 -> {
            Tuple4 tuple4 = x0$2;
            if (tuple4 != null) {
                Path tokenPath = (Path)tuple4._1();
                Path caPath = (Path)tuple4._2();
                Uri.Host serviceHost = (Uri.Host)tuple4._3();
                Port servicePort = (Port)tuple4._4();
                Uri.Host x$1 = serviceHost;
                Option x$2 = OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToInteger((int)servicePort.value())));
                Option x$3 = Uri.Authority$.MODULE$.apply$default$1();
                Uri x$4 = new Uri(OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)Uri.Scheme$.MODULE$.https())), OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)new Uri.Authority(x$3, x$1, x$2))), Uri$.MODULE$.apply$default$3(), Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
                Option x$5 = OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId(package.all$.MODULE$.toFunctorOps(Text$.MODULE$.readFile(tokenPath, F, Files$.MODULE$.forAsync(F)), (Functor)F).map((Function1 & Serializable)token -> new Authorization((Credentials)new Credentials.Token(AuthScheme$.MODULE$.Bearer(), token)))));
                Option x$6 = OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)caPath));
                Option<String> x$7 = MODULE$.of$default$3();
                Option<String> x$8 = MODULE$.of$default$5();
                Option<Path> x$9 = MODULE$.of$default$6();
                Option<String> x$10 = MODULE$.of$default$7();
                Option<Path> x$11 = MODULE$.of$default$8();
                Option<String> x$12 = MODULE$.of$default$9();
                Option<AuthInfoExec> x$13 = MODULE$.of$default$10();
                return MODULE$.of(x$4, (Option)x$5, x$7, (Option<Path>)x$6, x$8, x$9, x$10, x$11, x$12, x$13, (ApplicativeError)F);
            }
            throw new MatchError((Object)tuple4);
        }, F);
    }

    private <F> OptionT<F, Path> findHomeDir(Logger<F> evidence$18, Async<F> F) {
        return (OptionT)FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps((Object)OptionT$.MODULE$.liftF(Logger$.MODULE$.apply(evidence$18).debug((Function0 & Serializable)() -> "finding the home directory"), F), (FlatMap)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F)), (Function0 & Serializable)() -> MODULE$.envPath(MODULE$.EnvHome(), F).flatMapF((Function1 & Serializable)x$10 -> MODULE$.checkExists((Path)x$10, F), (Monad)F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$18).debug((Function0 & Serializable)() -> new StringBuilder(39).append(MODULE$.EnvHome()).append(" is not defined, or path does not exist").toString()), (Monad)F).orElse((Function0 & Serializable)() -> MODULE$.sysProp("os.name", F).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KubeConfig$.$anonfun$findHomeDir$7(x$11)), (Functor)F).flatMap((Function1 & Serializable)x$12 -> ((OptionT)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(MODULE$.env(MODULE$.EnvHomeDrive(), F), MODULE$.envPath(MODULE$.EnvHomePath(), F))).tupled((Invariant)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F), (Semigroupal)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String homeDrive = (String)tuple2._1();
                Path homePath = (Path)tuple2._2();
                return Path$.MODULE$.apply(homeDrive).resolve(homePath);
            }
            throw new MatchError((Object)tuple2);
        }, (Functor)F).flatMapF((Function1 & Serializable)x$13 -> MODULE$.checkExists((Path)x$13, F), (Monad)F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$18).debug((Function0 & Serializable)() -> new StringBuilder(51).append(MODULE$.EnvHomeDrive()).append(" and/or ").append(MODULE$.EnvHomePath()).append(" is/are not defined, or path does not exist").toString()), (Monad)F).orElse((Function0 & Serializable)() -> MODULE$.envPath(MODULE$.EnvUserProfile(), F).flatMapF((Function1 & Serializable)x$14 -> MODULE$.checkExists((Path)x$14, F), (Monad)F).flatTapNone((Function0 & Serializable)() -> Logger$.MODULE$.apply(evidence$18).debug((Function0 & Serializable)() -> new StringBuilder(39).append(MODULE$.EnvUserProfile()).append(" is not defined, or path does not exist").toString()), (Monad)F), (Monad)F), (Monad)F), (Monad)F), (FlatMap)OptionT$.MODULE$.catsDataMonadErrorForOptionT(F));
    }

    private <F> OptionT<F, String> sysProp(String name, Async<F> F) {
        return new OptionT(F.delay((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getProperty(name)).filterNot((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isEmpty()))));
    }

    private <F> OptionT<F, String> env(String name, Async<F> F) {
        return new OptionT(F.delay((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getenv(name)).filterNot((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isEmpty()))));
    }

    private <F> OptionT<F, Path> path(String path, Async<F> evidence$19) {
        return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)Path$.MODULE$.apply(path), evidence$19);
    }

    private <F> OptionT<F, Path> envPath(String name, Async<F> evidence$20) {
        return this.env(name, evidence$20).map((Function1 & Serializable)x$17 -> Path$.MODULE$.apply(x$17), evidence$20);
    }

    private <F> F checkExists(Path path, Async<F> evidence$21) {
        return (F)package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(Files$.MODULE$.forAsync(evidence$21)).exists(path), evidence$21).map((Function1 & Serializable)x$18 -> KubeConfig$.$anonfun$checkExists$1(path, BoxesRunTime.unboxToBoolean((Object)x$18)));
    }

    private <F> KubeConfig<F> apply(Uri server, Option<F> authorization, Option<String> caCertData, Option<Path> caCertFile, Option<String> clientCertData, Option<Path> clientCertFile, Option<String> clientKeyData, Option<Path> clientKeyFile, Option<String> clientKeyPass, Option<AuthInfoExec> authInfoExec, Option<Function1<F, F>> authorizationCache) {
        return new KubeConfig<F>(server, authorization, caCertData, caCertFile, clientCertData, clientCertFile, clientKeyData, clientKeyFile, clientKeyPass, authInfoExec, authorizationCache);
    }

    public <F> Option<Tuple11<Uri, Option<F>, Option<String>, Option<Path>, Option<String>, Option<Path>, Option<String>, Option<Path>, Option<String>, Option<AuthInfoExec>, Option<Function1<F, F>>>> unapply(KubeConfig<F> x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple11((Object)x$0.server(), x$0.authorization(), x$0.caCertData(), x$0.caCertFile(), x$0.clientCertData(), x$0.clientCertFile(), x$0.clientKeyData(), x$0.clientKeyFile(), x$0.clientKeyPass(), x$0.authInfoExec(), x$0.authorizationCache()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KubeConfig$.class);
    }

    public static final /* synthetic */ boolean $anonfun$of$1(AuthInfoExec x$2) {
        return x$2.interactiveMode().contains((Object)"Always");
    }

    public static final /* synthetic */ boolean $anonfun$of$2(AuthInfoExec x$3) {
        return x$3.provideClusterInfo().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ boolean $anonfun$findHomeDir$7(String x$11) {
        return x$11.toLowerCase().startsWith("windows");
    }

    public static final /* synthetic */ Option $anonfun$checkExists$1(Path path$4, boolean x$18) {
        if (x$18) {
            return Option$.MODULE$.apply((Object)path$4);
        }
        return package.all$.MODULE$.none();
    }

    private KubeConfig$() {
    }
}

