/*
 * Decompiled with CFR 0.152.
 */
package com.goyeau.kubernetes.client.util;

import com.goyeau.kubernetes.client.KubeConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SslContexts$ {
    public static final SslContexts$ MODULE$ = new SslContexts$();
    private static KeyStore defaultKeyStore;
    private static KeyStore defaultTrustStore;
    private static final String TrustStoreSystemProperty;
    private static String TrustStorePasswordSystemProperty;
    private static final String KeyStoreSystemProperty;
    private static String KeyStorePasswordSystemProperty;
    private static volatile byte bitmap$init$0;
    private static volatile byte bitmap$0;

    static {
        TrustStoreSystemProperty = "javax.net.ssl.trustStore";
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        TrustStorePasswordSystemProperty = "javax.net.ssl.trustStorePassword";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        KeyStoreSystemProperty = "javax.net.ssl.keyStore";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        KeyStorePasswordSystemProperty = "javax.net.ssl.keyStorePassword";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    private String TrustStoreSystemProperty() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/util/SslContexts.scala: 15");
        }
        return TrustStoreSystemProperty;
    }

    private String TrustStorePasswordSystemProperty() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/util/SslContexts.scala: 16");
        }
        return TrustStorePasswordSystemProperty;
    }

    private String KeyStoreSystemProperty() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/util/SslContexts.scala: 17");
        }
        return KeyStoreSystemProperty;
    }

    private String KeyStorePasswordSystemProperty() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/kubernetes-client/kubernetes-client/kubernetes-client/src/com/goyeau/kubernetes/client/util/SslContexts.scala: 18");
        }
        return KeyStorePasswordSystemProperty;
    }

    public <F> SSLContext fromConfig(KubeConfig<F> config) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers(config), this.trustManagers(config), new SecureRandom());
        return sslContext;
    }

    private <F> KeyManager[] keyManagers(KubeConfig<F> config) {
        Option certDataStream = config.clientCertData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = config.clientCertFile().map((Function1 & Serializable)x$1 -> x$1.toNioPath().toFile()).map((Function1 & Serializable)x$2 -> new FileInputStream((File)x$2));
        Option keyDataStream = config.clientKeyData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option keyFileStream = config.clientKeyFile().map((Function1 & Serializable)x$3 -> x$3.toNioPath().toFile()).map((Function1 & Serializable)x$4 -> new FileInputStream((File)x$4));
        keyDataStream.orElse((Function0 & Serializable)() -> keyFileStream).flatMap((Function1 & Serializable)keyStream -> certDataStream.orElse((Function0 & Serializable)() -> certFileStream).map((Function1 & Serializable)certStream -> {
            SslContexts$.$anonfun$keyManagers$10(keyStream, config, certStream);
            return BoxedUnit.UNIT;
        }));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.defaultKeyStore(), (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
        return keyManagerFactory.getKeyManagers();
    }

    /*
     * WARNING - void declaration
     */
    private KeyStore defaultKeyStore$lzycompute() {
        SslContexts$ sslContexts$ = this;
        synchronized (sslContexts$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                void var3_3;
                Option propertyKeyStoreFile = Option$.MODULE$.apply((Object)System.getProperty(this.KeyStoreSystemProperty(), "")).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6)))).map((Function1 & Serializable)x$7 -> new File((String)x$7));
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load((InputStream)propertyKeyStoreFile.map((Function1 & Serializable)x$8 -> new FileInputStream((File)x$8)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), System.getProperty(this.KeyStorePasswordSystemProperty(), "").toCharArray());
                defaultKeyStore = var3_3;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        KeyStorePasswordSystemProperty = null;
        return defaultKeyStore;
    }

    private KeyStore defaultKeyStore() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.defaultKeyStore$lzycompute();
        }
        return defaultKeyStore;
    }

    private <F> TrustManager[] trustManagers(KubeConfig<F> config) {
        Option certDataStream = config.caCertData().map((Function1 & Serializable)data -> new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
        Option certFileStream = config.caCertFile().map((Function1 & Serializable)x$9 -> x$9.toNioPath().toFile()).map((Function1 & Serializable)x$10 -> new FileInputStream((File)x$10));
        certDataStream.orElse((Function0 & Serializable)() -> certFileStream).foreach((Function1 & Serializable)certStream -> {
            SslContexts$.$anonfun$trustManagers$5(certStream);
            return BoxedUnit.UNIT;
        });
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.defaultTrustStore());
        return trustManagerFactory.getTrustManagers();
    }

    private KeyStore defaultTrustStore$lzycompute() {
        SslContexts$ sslContexts$ = this;
        synchronized (sslContexts$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                String securityDirectory = new StringBuilder(13).append(System.getProperty("java.home")).append("/lib/security").toString();
                Option propertyTrustStoreFile = Option$.MODULE$.apply((Object)System.getProperty(this.TrustStoreSystemProperty(), "")).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$12)))).map((Function1 & Serializable)x$13 -> new File((String)x$13));
                Option jssecacertsFile = Option$.MODULE$.apply((Object)new File(new StringBuilder(12).append(securityDirectory).append("/jssecacerts").toString())).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SslContexts$.$anonfun$defaultTrustStore$3(f)));
                File cacertsFile = new File(new StringBuilder(8).append(securityDirectory).append("/cacerts").toString());
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(new FileInputStream((File)propertyTrustStoreFile.orElse((Function0 & Serializable)() -> jssecacertsFile).getOrElse((Function0 & Serializable)() -> cacertsFile)), System.getProperty(this.TrustStorePasswordSystemProperty(), "changeit").toCharArray());
                defaultTrustStore = keyStore;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        TrustStorePasswordSystemProperty = null;
        return defaultTrustStore;
    }

    private KeyStore defaultTrustStore() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.defaultTrustStore$lzycompute();
        }
        return defaultTrustStore;
    }

    public static final /* synthetic */ void $anonfun$keyManagers$10(InputStream keyStream$1, KubeConfig config$1, InputStream certStream) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMKeyPair pemKeyPair = (PEMKeyPair)new PEMParser((Reader)new InputStreamReader(keyStream$1)).readObject();
        PrivateKey privateKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pemKeyPair.getPrivateKeyInfo());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(certStream);
        MODULE$.defaultKeyStore().setKeyEntry(certificate.getSubjectX500Principal().getName(), privateKey, (char[])config$1.clientKeyPass().fold((Function0 & Serializable)() -> (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()), (Function1 & Serializable)x$5 -> x$5.toCharArray()), (Certificate[])((Object[])new Certificate[]{certificate}));
    }

    public static final /* synthetic */ void $anonfun$trustManagers$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            X509Certificate certificate = (X509Certificate)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String alias = new StringBuilder(1).append(certificate.getSubjectX500Principal().getName()).append("-").append(i).toString();
            MODULE$.defaultTrustStore().setCertificateEntry(alias, certificate);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$trustManagers$5(InputStream certStream) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        Iterable certificates = CollectionConverters$.MODULE$.CollectionHasAsScala(certificateFactory.generateCertificates(certStream)).asScala();
        ((IterableOnceOps)((IterableOps)certificates.map((Function1 & Serializable)x$11 -> (X509Certificate)x$11)).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SslContexts$.$anonfun$trustManagers$7(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$defaultTrustStore$3(File f) {
        return f.exists() && f.isFile();
    }

    private SslContexts$() {
    }
}

