package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.
 *
 *  @param groupVersion  groupVersion is the group and version this APIResourceList is for.
 *  @param    resources  resources contains the name of the resources and if they are namespaced.
 *  @param   apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                       recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                       https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param         kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                       from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                       https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
*/
case class APIResourceList(
  groupVersion: String,
  resources: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource],
  apiVersion: Option[String] = None,
  kind: Option[String] = None
)

object APIResourceList {
  implicit lazy val encoder: Encoder.AsObject[APIResourceList] = deriveEncoder
  implicit lazy val decoder: Decoder[APIResourceList] = deriveDecoder
}
