package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *
 *  @param secretName  secretName is the  name of secret that contains Azure Storage Account Name and Key
 *  @param  shareName  shareName is the azure share Name
 *  @param   readOnly  readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts
*/
case class AzureFileVolumeSource(
  secretName: String,
  shareName: String,
  readOnly: Option[Boolean] = None
)

object AzureFileVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[AzureFileVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[AzureFileVolumeSource] = deriveDecoder
}
