package io.k8s.api.storage.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CSINodeSpec holds information about the specification of all CSI drivers installed on a node
 *
 *  @param drivers  drivers is a list of information of all CSI Drivers existing on a node. If all drivers in the list are
 *                  uninstalled, this can become empty.
*/
case class CSINodeSpec(
  drivers: Seq[io.k8s.api.storage.v1.CSINodeDriver]
)

object CSINodeSpec {
  implicit lazy val encoder: Encoder.AsObject[CSINodeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[CSINodeSpec] = deriveDecoder
}
