package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents storage that is managed by an external CSI volume driver (Beta feature)
 *
 *  @param                     driver  driver is the name of the driver to use for this volume. Required.
 *  @param               volumeHandle  volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume
 *                                     to refer to the volume on all subsequent calls. Required.
 *  @param  controllerExpandSecretRef  controllerExpandSecretRef is a reference to the secret object containing sensitive information
 *                                     to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This is an
 *                                     beta field and requires enabling ExpandCSIVolumes feature gate. This field is optional,
 *                                     and may be empty if no secret is required. If the secret object contains more than one
 *                                     secret, all secrets are passed.
 *  @param controllerPublishSecretRef  controllerPublishSecretRef is a reference to the secret object containing sensitive
 *                                     information to pass to the CSI driver to complete the CSI ControllerPublishVolume and
 *                                     ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret
 *                                     is required. If the secret object contains more than one secret, all secrets are passed
 *  @param                     fsType  fsType to mount. Must be a filesystem type supported by the host operating system. Ex.
 *                                     "ext4", "xfs", "ntfs".
 *  @param        nodeExpandSecretRef  nodeExpandSecretRef is a reference to the secret object containing sensitive information
 *                                     to pass to the CSI driver to complete the CSI NodeExpandVolume call. This is an alpha
 *                                     field and requires enabling CSINodeExpandSecret feature gate. This field is optional,
 *                                     may be omitted if no secret is required. If the secret object contains more than one
 *                                     secret, all secrets are passed.
 *  @param       nodePublishSecretRef  nodePublishSecretRef is a reference to the secret object containing sensitive information
 *                                     to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume
 *                                     calls. This field is optional, and may be empty if no secret is required. If the secret
 *                                     object contains more than one secret, all secrets are passed.
 *  @param         nodeStageSecretRef  nodeStageSecretRef is a reference to the secret object containing sensitive information
 *                                     to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and
 *                                     NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required.
 *                                     If the secret object contains more than one secret, all secrets are passed.
 *  @param                   readOnly  readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write)
 *  @param           volumeAttributes  volumeAttributes of the volume to publish.
*/
case class CSIPersistentVolumeSource(
  driver: String,
  volumeHandle: String,
  controllerExpandSecretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  controllerPublishSecretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  fsType: Option[String] = None,
  nodeExpandSecretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  nodePublishSecretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  nodeStageSecretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  readOnly: Option[Boolean] = None,
  volumeAttributes: Option[Map[String, String]] = None
)

object CSIPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[CSIPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[CSIPersistentVolumeSource] = deriveDecoder
}
