package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Adds and removes POSIX capabilities from running containers.
 *
 *  @param  add  Added capabilities
 *  @param drop  Removed capabilities
*/
case class Capabilities(
  add: Option[Seq[String]] = None,
  drop: Option[Seq[String]] = None
)

object Capabilities {
  implicit lazy val encoder: Encoder.AsObject[Capabilities] = deriveEncoder
  implicit lazy val decoder: Decoder[Capabilities] = deriveDecoder
}
