package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
 *
 *  @param   monitors  monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
 *  @param       path  path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
 *  @param   readOnly  readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
 *                     in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
 *  @param secretFile  secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
 *                     More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
 *  @param  secretRef  secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.
 *                     More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
 *  @param       user  user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
*/
case class CephFSVolumeSource(
  monitors: Seq[String],
  path: Option[String] = None,
  readOnly: Option[Boolean] = None,
  secretFile: Option[String] = None,
  secretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  user: Option[String] = None
)

object CephFSVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[CephFSVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[CephFSVolumeSource] = deriveDecoder
}
