package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
 *
 *  @param  volumeID  volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
 *  @param    fsType  fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system.
 *                    Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
 *                    https://examples.k8s.io/mysql-cinder-pd/README.md
 *  @param  readOnly  readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
 *                    More info: https://examples.k8s.io/mysql-cinder-pd/README.md
 *  @param secretRef  secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
*/
case class CinderVolumeSource(
  volumeID: String,
  fsType: Option[String] = None,
  readOnly: Option[Boolean] = None,
  secretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None
)

object CinderVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[CinderVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[CinderVolumeSource] = deriveDecoder
}
