package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ClientIPConfig represents the configurations of Client IP based session affinity.
 *
 *  @param timeoutSeconds  timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0
 *                         && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
*/
case class ClientIPConfig(
  timeoutSeconds: Option[Int] = None
)

object ClientIPConfig {
  implicit lazy val encoder: Encoder.AsObject[ClientIPConfig] = deriveEncoder
  implicit lazy val decoder: Decoder[ClientIPConfig] = deriveDecoder
}
