package io.k8s.api.rbac.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
 *
 *  @param aggregationRule  AggregationRule is an optional field that describes how to build the Rules for this ClusterRole.
 *                          If AggregationRule is set, then the Rules are controller managed and direct changes to Rules will
 *                          be stomped by the controller.
 *  @param      apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                          recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                          https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param            kind  Kind is a string value representing the REST resource this object represents. Servers may infer
 *                          this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                          https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param        metadata  Standard object's metadata.
 *  @param           rules  Rules holds all the PolicyRules for this ClusterRole
*/
case class ClusterRole(
  aggregationRule: Option[io.k8s.api.rbac.v1.AggregationRule] = None,
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  rules: Option[Seq[io.k8s.api.rbac.v1.PolicyRule]] = None
)

object ClusterRole {
  implicit lazy val encoder: Encoder.AsObject[ClusterRole] = deriveEncoder
  implicit lazy val decoder: Decoder[ClusterRole] = deriveDecoder
}
