package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Status of all the conditions for the component as a list of ComponentStatus objects. Deprecated: This API is deprecated in v1.19+
 *
 *  @param      items  List of ComponentStatus objects.
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
*/
case class ComponentStatusList(
  items: Seq[io.k8s.api.core.v1.ComponentStatus],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object ComponentStatusList {
  implicit lazy val encoder: Encoder.AsObject[ComponentStatusList] = deriveEncoder
  implicit lazy val decoder: Decoder[ComponentStatusList] = deriveDecoder
}
