package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ContainerStateWaiting is a waiting state of a container.
 *
 *  @param message  Message regarding why the container is not yet running.
 *  @param  reason  (brief) reason the container is not yet running.
*/
case class ContainerStateWaiting(
  message: Option[String] = None,
  reason: Option[String] = None
)

object ContainerStateWaiting {
  implicit lazy val encoder: Encoder.AsObject[ContainerStateWaiting] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStateWaiting] = deriveDecoder
}
