package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CrossVersionObjectReference contains enough information to let you identify the referred resource.
 *
 *  @param       kind  Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
 *  @param       name  Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names
 *  @param apiVersion  API version of the referent
*/
case class CrossVersionObjectReference(
  kind: String,
  name: String,
  apiVersion: Option[String] = None
)

object CrossVersionObjectReference {
  implicit lazy val encoder: Encoder.AsObject[CrossVersionObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[CrossVersionObjectReference] = deriveDecoder
}
