package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
 *
 *  @param     plural  plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`.
 *                     Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all
 *                     lowercase.
 *  @param       kind  kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource
 *                     instances will use this value as the `kind` attribute in API calls.
 *  @param categories  categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published
 *                     in API discovery documents, and used by clients to support invocations like `kubectl get all`.
 *  @param   listKind  listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
 *  @param shortNames  shortNames are short names for the resource, exposed in API discovery documents, and used by clients
 *                     to support invocations like `kubectl get <shortname>`. It must be all lowercase.
 *  @param   singular  singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`
*/
case class CustomResourceDefinitionNames(
  plural: String,
  kind: String,
  categories: Option[Seq[String]] = None,
  listKind: Option[String] = None,
  shortNames: Option[Seq[String]] = None,
  singular: Option[String] = None
)

object CustomResourceDefinitionNames {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionNames] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionNames] = deriveDecoder
}
