package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceValidation is a list of validation methods for CustomResources.
 *
 *  @param openAPIV3Schema  openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
*/
case class CustomResourceValidation(
  openAPIV3Schema: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = None
)

object CustomResourceValidation {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceValidation] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceValidation] = deriveDecoder
}
