package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DaemonEndpoint contains information about a single Daemon endpoint.
 *
 *  @param Port  Port number of the given endpoint.
*/
case class DaemonEndpoint(
  Port: Int
)

object DaemonEndpoint {
  implicit lazy val encoder: Encoder.AsObject[DaemonEndpoint] = deriveEncoder
  implicit lazy val decoder: Decoder[DaemonEndpoint] = deriveDecoder
}
