package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DaemonSet represents the configuration of a daemon set.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
 *  @param     status  The current status of this daemon set. This data may be out of date by some window of time. Populated
 *                     by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class DaemonSet(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.apps.v1.DaemonSetSpec] = None,
  status: Option[io.k8s.api.apps.v1.DaemonSetStatus] = None
)

object DaemonSet {
  implicit lazy val encoder: Encoder.AsObject[DaemonSet] = deriveEncoder
  implicit lazy val decoder: Decoder[DaemonSet] = deriveDecoder
}
