package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
 *
 *  @param rollingUpdate  Rolling update config params. Present only if type = "RollingUpdate".
 *  @param        `type`  Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
*/
case class DaemonSetUpdateStrategy(
  rollingUpdate: Option[io.k8s.api.apps.v1.RollingUpdateDaemonSet] = None,
  `type`: Option[String] = None
)

object DaemonSetUpdateStrategy {
  implicit lazy val encoder: Encoder.AsObject[DaemonSetUpdateStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[DaemonSetUpdateStrategy] = deriveDecoder
}
