package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Deployment enables declarative updates for Pods and ReplicaSets.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  Specification of the desired behavior of the Deployment.
 *  @param     status  Most recently observed status of the Deployment.
*/
case class Deployment(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.apps.v1.DeploymentSpec] = None,
  status: Option[io.k8s.api.apps.v1.DeploymentStatus] = None
)

object Deployment {
  implicit lazy val encoder: Encoder.AsObject[Deployment] = deriveEncoder
  implicit lazy val decoder: Decoder[Deployment] = deriveDecoder
}
