package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DeploymentSpec is the specification of the desired behavior of the Deployment.
 *
 *  @param                selector  Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the
 *                                  ones affected by this deployment. It must match the pod template's labels.
 *  @param                template  Template describes the pods that will be created.
 *  @param         minReadySeconds  Minimum number of seconds for which a newly created pod should be ready without any of
 *                                  its container crashing, for it to be considered available. Defaults to 0 (pod will be considered
 *                                  available as soon as it is ready)
 *  @param                  paused  Indicates that the deployment is paused.
 *  @param progressDeadlineSeconds  The maximum time in seconds for a deployment to make progress before it is considered to
 *                                  be failed. The deployment controller will continue to process failed deployments and a condition
 *                                  with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that
 *                                  progress will not be estimated during the time a deployment is paused. Defaults to 600s.
 *  @param                replicas  Number of desired pods. This is a pointer to distinguish between explicit zero and not
 *                                  specified. Defaults to 1.
 *  @param    revisionHistoryLimit  The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish
 *                                  between explicit zero and not specified. Defaults to 10.
 *  @param                strategy  The deployment strategy to use to replace existing pods with new ones.
*/
case class DeploymentSpec(
  selector: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  template: io.k8s.api.core.v1.PodTemplateSpec,
  minReadySeconds: Option[Int] = None,
  paused: Option[Boolean] = None,
  progressDeadlineSeconds: Option[Int] = None,
  replicas: Option[Int] = None,
  revisionHistoryLimit: Option[Int] = None,
  strategy: Option[io.k8s.api.apps.v1.DeploymentStrategy] = None
)

object DeploymentSpec {
  implicit lazy val encoder: Encoder.AsObject[DeploymentSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[DeploymentSpec] = deriveDecoder
}
