package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DeploymentStatus is the most recently observed status of the Deployment.
 *
 *  @param   availableReplicas  Total number of available pods (ready for at least minReadySeconds) targeted by this deployment
 *  @param      collisionCount  Count of hash collisions for the Deployment. The Deployment controller uses this field as a
 *                              collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
 *  @param          conditions  Represents the latest available observations of a deployment's current state.
 *  @param  observedGeneration  The generation observed by the deployment controller.
 *  @param       readyReplicas  readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
 *  @param            replicas  Total number of non-terminated pods targeted by this deployment (their labels match the selector)
 *  @param unavailableReplicas  Total number of unavailable pods targeted by this deployment. This is the total number of pods
 *                              that are still required for the deployment to have 100% available capacity. They may either
 *                              be pods that are running but not yet available or pods that still have not been created.
 *  @param     updatedReplicas  Total number of non-terminated pods targeted by this deployment that have the desired template
 *                              spec.
*/
case class DeploymentStatus(
  availableReplicas: Option[Int] = None,
  collisionCount: Option[Int] = None,
  conditions: Option[Seq[io.k8s.api.apps.v1.DeploymentCondition]] = None,
  observedGeneration: Option[Long] = None,
  readyReplicas: Option[Int] = None,
  replicas: Option[Int] = None,
  unavailableReplicas: Option[Int] = None,
  updatedReplicas: Option[Int] = None
)

object DeploymentStatus {
  implicit lazy val encoder: Encoder.AsObject[DeploymentStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[DeploymentStatus] = deriveDecoder
}
