package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DeploymentStrategy describes how to replace existing pods with new ones.
 *
 *  @param rollingUpdate  Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
 *  @param        `type`  Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
*/
case class DeploymentStrategy(
  rollingUpdate: Option[io.k8s.api.apps.v1.RollingUpdateDeployment] = None,
  `type`: Option[String] = None
)

object DeploymentStrategy {
  implicit lazy val encoder: Encoder.AsObject[DeploymentStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[DeploymentStrategy] = deriveDecoder
}
