package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
 *
 *  @param defaultMode  Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions
 *                      on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between
 *                      0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults
 *                      to 0644. Directories within the path are not affected by this setting. This might be in conflict with
 *                      other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
 *  @param       items  Items is a list of downward API volume file
*/
case class DownwardAPIVolumeSource(
  defaultMode: Option[Int] = None,
  items: Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
)

object DownwardAPIVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[DownwardAPIVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[DownwardAPIVolumeSource] = deriveDecoder
}
