package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EnvVar represents an environment variable present in a Container.
 *
 *  @param      name  Name of the environment variable. Must be a C_IDENTIFIER.
 *  @param     value  Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the
 *                    container and any service environment variables. If a variable cannot be resolved, the reference in the
 *                    input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME)
 *                    syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never
 *                    be expanded, regardless of whether the variable exists or not. Defaults to "".
 *  @param valueFrom  Source for the environment variable's value. Cannot be used if value is not empty.
*/
case class EnvVar(
  name: String,
  value: Option[String] = None,
  valueFrom: Option[io.k8s.api.core.v1.EnvVarSource] = None
)

object EnvVar {
  implicit lazy val encoder: Encoder.AsObject[EnvVar] = deriveEncoder
  implicit lazy val decoder: Decoder[EnvVar] = deriveDecoder
}
