package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EnvVarSource represents a source for the value of an EnvVar.
 *
 *  @param  configMapKeyRef  Selects a key of a ConfigMap.
 *  @param         fieldRef  Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`,
 *                           `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP,
 *                           status.podIPs.
 *  @param resourceFieldRef  Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory,
 *                           limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently
 *                           supported.
 *  @param     secretKeyRef  Selects a key of a secret in the pod's namespace
*/
case class EnvVarSource(
  configMapKeyRef: Option[io.k8s.api.core.v1.ConfigMapKeySelector] = None,
  fieldRef: Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  resourceFieldRef: Option[io.k8s.api.core.v1.ResourceFieldSelector] = None,
  secretKeyRef: Option[io.k8s.api.core.v1.SecretKeySelector] = None
)

object EnvVarSource {
  implicit lazy val encoder: Encoder.AsObject[EnvVarSource] = deriveEncoder
  implicit lazy val decoder: Decoder[EnvVarSource] = deriveDecoder
}
