package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
 *
 *  @param           metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param     involvedObject  The object that this event is about.
 *  @param             action  What action was taken/failed regarding to the Regarding object.
 *  @param         apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should
 *                             convert recognized schemas to the latest internal value, and may reject unrecognized values.
 *                             More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param              count  The number of times this event has occurred.
 *  @param          eventTime  Time when this Event was first observed.
 *  @param     firstTimestamp  The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
 *  @param               kind  Kind is a string value representing the REST resource this object represents. Servers may infer
 *                             this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More
 *                             info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param      lastTimestamp  The time at which the most recent occurrence of this event was recorded.
 *  @param            message  A human-readable description of the status of this operation.
 *  @param             reason  This should be a short, machine understandable string that gives the reason for the transition
 *                             into the object's current status.
 *  @param            related  Optional secondary object for more complex actions.
 *  @param reportingComponent  Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
 *  @param  reportingInstance  ID of the controller instance, e.g. `kubelet-xyzf`.
 *  @param             series  Data about the Event series this event represents or nil if it's a singleton Event.
 *  @param             source  The component reporting this event. Should be a short machine understandable string.
 *  @param             `type`  Type of this event (Normal, Warning), new types could be added in the future
*/
case class Event(
  metadata: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta,
  involvedObject: io.k8s.api.core.v1.ObjectReference,
  action: Option[String] = None,
  apiVersion: Option[String] = None,
  count: Option[Int] = None,
  eventTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  firstTimestamp: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  kind: Option[String] = None,
  lastTimestamp: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None,
  related: Option[io.k8s.api.core.v1.ObjectReference] = None,
  reportingComponent: Option[String] = None,
  reportingInstance: Option[String] = None,
  series: Option[io.k8s.api.core.v1.EventSeries] = None,
  source: Option[io.k8s.api.core.v1.EventSource] = None,
  `type`: Option[String] = None
)

object Event {
  implicit lazy val encoder: Encoder.AsObject[Event] = deriveEncoder
  implicit lazy val decoder: Decoder[Event] = deriveDecoder
}
