package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
 *
 *  @param    driver  driver is the name of the driver to use for this volume.
 *  @param    fsType  fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system.
 *                    Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
 *  @param   options  options is Optional: this field holds extra command options if any.
 *  @param  readOnly  readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in
 *                    VolumeMounts.
 *  @param secretRef  secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to
 *                    pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains
 *                    more than one secret, all secrets are passed to the plugin scripts.
*/
case class FlexPersistentVolumeSource(
  driver: String,
  fsType: Option[String] = None,
  options: Option[Map[String, String]] = None,
  readOnly: Option[Boolean] = None,
  secretRef: Option[io.k8s.api.core.v1.SecretReference] = None
)

object FlexPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[FlexPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[FlexPersistentVolumeSource] = deriveDecoder
}
