package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** HTTPHeader describes a custom header to be used in HTTP probes
 *
 *  @param  name  The header field name
 *  @param value  The header field value
*/
case class HTTPHeader(
  name: String,
  value: String
)

object HTTPHeader {
  implicit lazy val encoder: Encoder.AsObject[HTTPHeader] = deriveEncoder
  implicit lazy val decoder: Decoder[HTTPHeader] = deriveDecoder
}
