package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
 *
 *  @param hostnames  Hostnames for the above IP address.
 *  @param        ip  IP address of the host file entry.
*/
case class HostAlias(
  hostnames: Option[Seq[String]] = None,
  ip: Option[String] = None
)

object HostAlias {
  implicit lazy val encoder: Encoder.AsObject[HostAlias] = deriveEncoder
  implicit lazy val decoder: Decoder[HostAlias] = deriveDecoder
}
