package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IPBlock describes a particular CIDR (Ex. "192.168.1.1/24","2001:db9::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
 *
 *  @param   cidr  CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64"
 *  @param except  Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24"
 *                 or "2001:db9::/64" Except values will be rejected if they are outside the CIDR range
*/
case class IPBlock(
  cidr: String,
  except: Option[Seq[String]] = None
)

object IPBlock {
  implicit lazy val encoder: Encoder.AsObject[IPBlock] = deriveEncoder
  implicit lazy val decoder: Decoder[IPBlock] = deriveDecoder
}
