package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressBackend describes all endpoints for a given service and port.
 *
 *  @param resource  Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource
 *                   is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting
 *                   with "Service".
 *  @param  service  Service references a Service as a Backend. This is a mutually exclusive setting with "Resource".
*/
case class IngressBackend(
  resource: Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  service: Option[io.k8s.api.networking.v1.IngressServiceBackend] = None
)

object IngressBackend {
  implicit lazy val encoder: Encoder.AsObject[IngressBackend] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressBackend] = deriveDecoder
}
