package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
 *
 *  @param      key  key is the label key that the selector applies to.
 *  @param operator  operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and
 *                   DoesNotExist.
 *  @param   values  values is an array of string values. If the operator is In or NotIn, the values array must be non-empty.
 *                   If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during
 *                   a strategic merge patch.
*/
case class LabelSelectorRequirement(
  key: String,
  operator: String,
  values: Option[Seq[String]] = None
)

object LabelSelectorRequirement {
  implicit lazy val encoder: Encoder.AsObject[LabelSelectorRequirement] = deriveEncoder
  implicit lazy val decoder: Decoder[LabelSelectorRequirement] = deriveDecoder
}
