package io.k8s.api.coordination.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LeaseSpec is a specification of a Lease.
 *
 *  @param          acquireTime  acquireTime is a time when the current lease was acquired.
 *  @param       holderIdentity  holderIdentity contains the identity of the holder of a current lease.
 *  @param leaseDurationSeconds  leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire
 *                               it. This is measure against time of last observed RenewTime.
 *  @param     leaseTransitions  leaseTransitions is the number of transitions of a lease between holders.
 *  @param            renewTime  renewTime is a time when the current holder of a lease has last updated the lease.
*/
case class LeaseSpec(
  acquireTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  holderIdentity: Option[String] = None,
  leaseDurationSeconds: Option[Int] = None,
  leaseTransitions: Option[Int] = None,
  renewTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
)

object LeaseSpec {
  implicit lazy val encoder: Encoder.AsObject[LeaseSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[LeaseSpec] = deriveDecoder
}
