package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
 *
 *  @param               `type`  Type of resource that this limit applies to.
 *  @param              default  Default resource requirement limit value by resource name if resource limit is omitted.
 *  @param       defaultRequest  DefaultRequest is the default resource requirement request value by resource name if resource
 *                               request is omitted.
 *  @param                  max  Max usage constraints on this kind by resource name.
 *  @param maxLimitRequestRatio  MaxLimitRequestRatio if specified, the named resource must have a request and limit that are
 *                               both non-zero where limit divided by request is less than or equal to the enumerated value;
 *                               this represents the max burst for the named resource.
 *  @param                  min  Min usage constraints on this kind by resource name.
*/
case class LimitRangeItem(
  `type`: String,
  default: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  defaultRequest: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  max: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  maxLimitRequestRatio: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  min: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object LimitRangeItem {
  implicit lazy val encoder: Encoder.AsObject[LimitRangeItem] = deriveEncoder
  implicit lazy val decoder: Decoder[LimitRangeItem] = deriveDecoder
}
